<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1><?= labels('payment_request', "Payment Request") ?></h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="<?= base_url('/admin/dashboard') ?>"><i class="fas fa-home-alt text-primary"></i> <?= labels('Dashboard', 'Dashboard') ?></a></div>
                <div class="breadcrumb-item"><a href="<?= base_url('/admin/partners') ?>"><i class="fas fa-handshake text-warning"></i> <?= labels('provider', 'Provider') ?></a></div>
                <div class="breadcrumb-item"><?= labels('payment_request', 'Payment Requests') ?></div>
            </div>
        </div>
        <div class="container-fluid card">
            <h2 class='section-title'><?= labels('payment_requests_by_provider', 'Payment Requests by Provider') ?></h2>
            <div class="row mb-3">
                <div class="col-12">
                    <table class="table table-striped" id="payment_request_list" data-detail-formatter="user_formater"
                     data-auto-refresh="true" data-toggle="table" data-url="<?= base_url("admin/partners/payment_request_list") ?>" 
                     data-side-pagination="server" data-pagination="true" data-page-list="[5, 10, 25, 50, 100, 200, All]"
                      data-search="true" data-show-columns="true" data-show-columns-search="true" data-show-refresh="true" 
                      data-sort-order="desc">
                        <thead>
                            <tr>
                                <th data-field="id" class="text-center" data-visible="true" data-sortable="true"><?= labels('id', 'ID') ?></th>
                                <th data-field="user_id" class="text-center" data-visible="false" data-sortable="true"><?= labels('user_id', 'User ID') ?></th>
                                <th data-field="partner_name" class="text-center" data-visible="true" data-sortable="true"><?= labels('provider_name', 'Provider Name') ?></th>
                                <th data-field="user_type" class="text-center" data-visible="true" data-sortable="true"><?= labels('user_type', 'User Type') ?></th>
                                <th data-field="payment_address" class="text-center" data-visible="true"><?= labels('payment_address', 'Payment Address') ?></th>
                                <th data-field="amount" class="text-center" data-visible="true" data-sortable="true"><?= labels('amount', 'Amount') ?></th>
                                <th data-field="remarks" class="text-center" data-visible="true"><?= labels('remarks', 'remarks') ?></th>
                                <th data-field="status" class="text-center" data-visible="true" data-sortable="true"><?= labels('status', 'status') ?></th>
                                <th data-field="created_at" class="text-center" data-visible="true" data-sortable="true"><?= labels('created_at', 'Date Created') ?></th>


                                <th data-field="operations" class="text-center" data-events="payment_events"><?= labels('operations', 'Operations') ?></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<div class="modal fade" id="edit_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?= labels('settle_payment_request', "Settle Payment Request") ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?= base_url('admin/partners/pay_partner') ?>" method="post" id="pay_partner" class="form-submit-event">
                <div class="modal-body">
                    <input id="request_id" class="form-control" type="hidden" name="request_id">
                    <input id="user_id" class="form-control" type="hidden" name="user_id">
                    <input id="amount" class="form-control" type="hidden" name="amount">



                    <div class="row">
                        <!-- <div class="col-md">
                            <div class="custom-control custom-switch">
                                <input id="dis_approved" class="custom-control-input" type="checkbox" name="status" value="approved" checked>
                                <label for="dis_approved" class="custom-control-label">
                                    <p id="para"><?= labels('approve', "Approve") ?></p>
                                </label>

                            </div>
                        </div> -->

                        <div class="col-md">
                            <div class="form-group">
                                <label><?= labels('status', 'Status') ?><span class="text-danger text-sm">*</span></label>
                                <br>
                                <div id="dis_approved" class="btn-group ">
                                    <label class="btn btn-warning" data-toggle-class="btn-warning" data-toggle-passive-class="btn-default">
                                        <input type="radio" name="status" value="0"><?= labels('pending', 'Pending') ?>
                                    </label>
                                    <label class="btn btn-primary" data-toggle-class="btn-primary" data-toggle-passive-class="btn-default">
                                        <input type="radio" name="status" value="1"><?= labels('approved', 'Approved') ?>
                                    </label>
                                    <label class="btn btn-danger" data-toggle-class="btn-danger" data-toggle-passive-class="btn-default">
                                        <input type="radio" name="status" value="2" checked> <?= labels('not_approved', 'Not approved') ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md">
                            <label for="message"><?= labels('message', "Message") ?></label>
                            <textarea rows="2" cols="20" class='form-control' name="reason" id="message"></textarea>
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><?= labels('update', "Update") ?></button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= labels('close', "Close") ?></button>
                </div>
            </form>
        </div>
    </div>
</div>